require( "scripts/style.lua" );

kButtonX = 125;
kButtonY = 120;
kButtonSpacingX = 195;
kButtonSpacingY = 190;
kButtonWidth = 175;
kButtonHeight = 203;
kScoreSpacingY = 27.6;

selectedactivity = ""
selectedgamemode = 0;
selectedlevel = 0;

function UpdateSceneList( curUser, numUsers, userTable )
end

TextStyle=
{
	parent=DialogBodyText,
	--align=kHAlignLeft+kVAlignCenter,
	flags=kVAlignTop+kHAlignCenter,
	x=0,y=130,w=kMax,h=kMax
};

LockedTextStyle = 
{
	parent=TextStyle,
	font = { standardFont, 16, RedColor },
};

UnlockedTextStyle = 
{
	parent=TextStyle,
	font = { standardFont, 16, BlackColor },
};

ActivityHeaderTextStyle = 
{
	parent=TextStyle,
	font = {standardFont, 28, BlackColor },
};

ActivityHeaderSmallTextStyle = 
{
	parent=TextStyle,
	font = {standardFont, 16, BlackColor },
};

ActivityScoreTextStyle = 
{
	parent=TextStyle,
	font = {standardFont, 16, BlackColor },
};

ActivitySubHeaderTextStyle = 
{
	parent=TextStyle,
	font = {standardFont, 16, BlackColor },
};

function GetLockedWindow(window_name, col, row)
	return {
		name= window_name .. "_locked",
		w=kButtonWidth,h=kButtonHeight,
		x=kButtonX + kButtonSpacingX * col,
		y=kButtonY + kButtonSpacingY * row,
		
		Button
		{
			align=kHAlignLeft+kVAlignTop,
			graphics = { "buttons/activity_" .. window_name .. "_gray", "buttons/activity_" .. window_name .. "_gray", "buttons/activity_" .. window_name .. "_gray" },
		},
		--[[
		Bitmap
		{
			align=kHAlignCenter+kVAlignTop,
			x = kButtonWidth/2,
			y = 20,
			image = "buttons/activity_" .. window_name .. "_locked",
			mask = exists("buttons/activity_" .. window_name .. "_locked.mask.png"),
		},
		--]]
		SetStyle(LockedTextStyle),
		Text
		{
			label="locked",
			w = 100,
			x = kButtonWidth/2 - 50,
			y = 0,
			flags=kVAlignBottom+kHAlignCenter,
			h = 155,
		},
	};
end

function GetUnLockedWindow(window_name, col, row)
	return {
		name= window_name .. "_unlocked",
		w=kButtonWidth,h=kButtonHeight,
		x=kButtonX + kButtonSpacingX * col,
		y=kButtonY + kButtonSpacingY * row,
		
		Button
		{
			align=kHAlignLeft+kVAlignTop,
			graphics = { "buttons/activity_" .. window_name, "buttons/activity_" .. window_name .. "_highlight", "buttons/activity_" .. window_name .. "_highlight" },
			command=function() GotoSubMenu(window_name); end;
		},
		--[[
		Bitmap
		{
			align=kHAlignCenter+kVAlignTop,
			x = kButtonWidth/2,
			y = 20,
			image = "buttons/activity_" .. window_name .. "_unlocked",
			mask = exists("buttons/activity_" .. window_name .. "_unlocked.mask.png"),
		},
		--]]
		SetStyle(UnlockedTextStyle),
		Text
		{
			label="activity_" .. window_name,
			w = 100,
			x = kButtonWidth/2 - 50,
			y = 0,
			flags=kVAlignBottom+kHAlignCenter,
			h = 155,
		},
	};
end

function CreateScores(xPos, yPos, startNum, endNum)
	
	local bestscoreoffset = 100;
	local t = { SetStyle(ActivitySubHeaderTextStyle), };
	table.insert(t, 
		Text
		{
			flags=kVAlignTop+kHAlignRight,
			label = "level",
			name = "leveltext_" .. startNum,
			x=xPos,
			y=yPos,
			w = 60,
		}
	);
	table.insert(t, 
		Text
		{
			flags=kVAlignTop+kHAlignLeft,
			label = "bestscore",
			name = "bestscoretext_" .. startNum,
			x=xPos+bestscoreoffset,
			y=yPos,
		}
	);
	for i = 0,(endNum-startNum) do
		table.insert(t, 
			Text
			{
				flags=kVAlignCenter+kHAlignRight,
				font = {standardFont, 18, BlackColor },
				label = i+startNum,
				name = "scorenum_" .. i+startNum .. "_unlocked",
				x=xPos,
				y=yPos+(i+1)*kScoreSpacingY,
				w = 50,
				h = 29,
			}
		);
		
		table.insert(t, 
			Text
			{
				flags=kVAlignCenter+kHAlignRight,
				font = {standardFont, 18, RedColor },
				label = i+startNum,
				name = "scorenum_" .. i+startNum .. "_locked",
				x=xPos,
				y=yPos+(i+1)*kScoreSpacingY,
				w = 50,
				h = 29,
			}
		);
		
		table.insert(t, 
			Text
			{
				flags=kVAlignCenter+kHAlignRight,
				font = {standardFont, 18, BlueColor },
				label = 0,
				name = "score_" .. i+startNum,
				x=xPos+bestscoreoffset,
				y=yPos+(i+1)*kScoreSpacingY,
				w = 60,
				h = 29,
			}
		);
		
		table.insert(t, 
			Bitmap
			{
				align=kHAlignRight+kVAlignTop,
				image = "buttons/activity_level_expert",
				mask = exists("buttons/activity_level_expert.mask.png"),
				name = "expert_" .. i+startNum,
				x=xPos+bestscoreoffset+150,
				y=yPos+(i+1)*kScoreSpacingY+4,
				w =50,
			}
		);
	end
	
	return Group(t);
end

LevelSelectButtonStyle = 
{
	parent=ButtonStyle,
	type = kRadio,
	align=kHAlignLeft+kVAlignTop,
	label = "",
	graphics = { "buttons/blank", "buttons/activity_level_selected", "buttons/blank", "buttons/activity_level_selected" },
	
};

-- probably a lot of magic numbers in this function, but meh
function CreateLevelSelectButtons(xPos, yPos, xPos2, yPos2)
	local t = { SetStyle(LevelSelectButtonStyle), BeginGroup() };

	--[[
	for i = 0,10 do
		table.insert(t, 
			Button
			{
				name = "levelbutton_" .. i+1,
				x = 130,
				y = 145 + i*kScoreSpacingY,
				
				command = function() selectedlevel = i+1; end;
			}
		);
	end
	--]]
	table.insert(t, Button{	on = true, name = "levelbutton_1", x = xPos, y = yPos + 0*kScoreSpacingY, command = function() selectedlevel = 1; end; } );
	table.insert(t, Button{	name = "levelbutton_2", x = xPos, y = yPos + 1*kScoreSpacingY, command = function() selectedlevel = 2; end; } );
	table.insert(t, Button{	name = "levelbutton_3", x = xPos, y = yPos + 2*kScoreSpacingY, command = function() selectedlevel = 3; end; } );
	table.insert(t, Button{	name = "levelbutton_4", x = xPos, y = yPos + 3*kScoreSpacingY, command = function() selectedlevel = 4; end; } );
	table.insert(t, Button{	name = "levelbutton_5", x = xPos, y = yPos + 4*kScoreSpacingY, command = function() selectedlevel = 5; end; } );
	table.insert(t, Button{	name = "levelbutton_6", x = xPos, y = yPos + 5*kScoreSpacingY, command = function() selectedlevel = 6; end; } );
	table.insert(t, Button{	name = "levelbutton_7", x = xPos, y = yPos + 6*kScoreSpacingY, command = function() selectedlevel = 7; end; } );
	table.insert(t, Button{	name = "levelbutton_8", x = xPos, y = yPos + 7*kScoreSpacingY, command = function() selectedlevel = 8; end; } );
	--table.insert(t, Button{	name = "levelbutton_9", x = xPos, y = yPos + 8*kScoreSpacingY, command = function() selectedlevel = 9; end; } );
	--table.insert(t, Button{	name = "levelbutton_10", x = xPos, y = yPos + 9*kScoreSpacingY, command = function() selectedlevel = 10; end; } );
	
	--[[
	for i = 10,20 do
		table.insert(t, 
			Button
			{
				name = "levelbutton_" .. i+1,
				x = 430,
				y = 145+ (i-10)*kScoreSpacingY,
				
				command = function() selectedlevel = i+1; end;
			}
		);
	end
	--]]
	table.insert(t, Button{	name = "levelbutton_9", x = xPos2, y = yPos2 + 0*kScoreSpacingY, command = function() selectedlevel = 9; end; } );
	table.insert(t, Button{	name = "levelbutton_10", x = xPos2, y = yPos2 + 1*kScoreSpacingY, command = function() selectedlevel = 10; end; } );
	table.insert(t, Button{	name = "levelbutton_11", x = xPos2, y = yPos2 + 2*kScoreSpacingY, command = function() selectedlevel = 11; end; } );
	table.insert(t, Button{	name = "levelbutton_12", x = xPos2, y = yPos2 + 3*kScoreSpacingY, command = function() selectedlevel = 12; end; } );
	table.insert(t, Button{	name = "levelbutton_13", x = xPos2, y = yPos2 + 4*kScoreSpacingY, command = function() selectedlevel = 13; end; } );
	table.insert(t, Button{	name = "levelbutton_14", x = xPos2, y = yPos2 + 5*kScoreSpacingY, command = function() selectedlevel = 14; end; } );
	table.insert(t, Button{	name = "levelbutton_15", x = xPos2, y = yPos2 + 6*kScoreSpacingY, command = function() selectedlevel = 15; end; } );
	table.insert(t, Button{	name = "levelbutton_16", x = xPos2, y = yPos2 + 7*kScoreSpacingY, command = function() selectedlevel = 16; end; } );
	--table.insert(t, Button{	name = "levelbutton_19", x = xPos2, y = yPos2 + 8*kScoreSpacingY, command = function() selectedlevel = 19; end; } );
	--table.insert(t, Button{	name = "levelbutton_20", x = xPos2, y = yPos2 + 9*kScoreSpacingY, command = function() selectedlevel = 20; end; } );
	
	return Group(t);
end

function GotoMainMenu()
	CloseWindow();
end;

MakeDialog
{
	-- Name the modal dialog
	name="activitymode",
	
	--TActivityModeMenu
	--{
		Bitmap
		{
			image = "backgrounds/fullscreendialog",
			mask = exists("backgrounds/fullscreendialog.mask.png"),
			x=kCenter,
			y=kCenter,

			Window
			{
				name="activitymenu",
				w=kMax,h=kMax,

				--SetStyle(TextStyle),
				--Text
				--{
				--	label="help1",
				--},
			
				SetStyle(ButtonStyle),
				Button
				{
					label="",
					name="back",
					cancel=true,
					rolloversound = "audio/sfx/pause_rollover";
					align=kHAlignLeft+kVAlignBottom,
					x=20,y=kMax,
					graphics = { "buttons/button_back_up", "buttons/button_back_down", "buttons/button_back_over" },
					command=function() GotoMainMenu(); end;
				},
				Text
				{
					label="back",
					name="back_text",
					font = BackButtonFont,
					flags = kVAlignTop + kHAlignCenter,
					x=27,y=kMax-70,
					w=50,
					h=40,
				},
				--[[
				Button
				{
					label="",
					name="quit",
					default=true,
					align=kHAlignRight+kVAlignBottom,
					x=kMax-20,y=kMax,
					graphics = { "buttons/button_pause_up", "buttons/button_pause_down", "buttons/button_pause_over" },
					command=function() GotoMainMenu(); end;
				},
				--]]
				Window(GetLockedWindow("beading", 0, 0));
				Window(GetUnLockedWindow("beading", 0, 0));
				
				Window(GetLockedWindow("clothing", 1, 0));
				Window(GetUnLockedWindow("clothing", 1, 0));
				
				Window(GetLockedWindow("package", 2, 0));
				Window(GetUnLockedWindow("package", 2, 0));
				
				Window(GetLockedWindow("chicken_field", 0, 1));
				Window(GetUnLockedWindow("chicken_field", 0, 1));
				
				Window(GetLockedWindow("chicken_chorus", 1, 1));
				Window(GetUnLockedWindow("chicken_chorus", 1, 1));
				
				Window(GetLockedWindow("dough_ball", 2, 1));
				Window(GetUnLockedWindow("dough_ball", 2, 1));
				
				SetStyle(ActivityHeaderTextStyle);
				Text
				{
					label = "activitymode",
					y = 37,
				},
				--[[
				SetStyle(ActivitySubHeaderTextStyle);
				Text
				{
					label = "activitymodesubheader",
					y = 55,
				},
				--]]
				SetStyle(ActivitySubHeaderTextStyle);
				Text
				{
					label = "activitymodenote",
					y = 500,
					x = 200,
					w = 400,
				},
			},
			
			Window
			{
				name="activitysubmenu",
				w=kMax,h=kMax,
				
				Bitmap
				{
					image = "backgrounds/activity_level_list_area",
					mask = exists("backgrounds/activity_level_list_area.mask.png"),
				},
				--[[
				Bitmap
				{
					image = "backgrounds/activityscore",
					mask = exists("backgrounds/activityscore.mask.png"),
					name = "scoreleft",
					x=kCenter-150,
					y=kCenter+20,
				},
				
				Bitmap
				{
					image = "backgrounds/activityscore",
					mask = exists("backgrounds/activityscore.mask.png"),
					name = "scoreright",
					x=kCenter+150,
					y=kCenter+20,
				},
				--]]
				CreateLevelSelectButtons(135, 220, 419, 220);
				
				CreateScores(150, 190, 1, 8);
				
				CreateScores(440, 190, 9, 16);
				
				Bitmap
				{
					name = "activity_beading_unlocked",
					image = "buttons/activity_level_beading",
					mask = exists("buttons/activity_level_beading.mask.png"),
				},
				
				Bitmap
				{
					name = "activity_clothing_unlocked",
					image = "buttons/activity_level_clothing",
					mask = exists("buttons/activity_level_clothing.mask.png"),
				},
				
				Bitmap
				{
					name = "activity_package_unlocked",
					image = "buttons/activity_level_package",
					mask = exists("buttons/activity_level_package.mask.png"),
				},
				
				Bitmap
				{
					name = "activity_chicken_field_unlocked",
					image = "buttons/activity_level_chicken_field",
					mask = exists("buttons/activity_level_chicken_field.mask.png"),
				},
				
				Bitmap
				{
					name = "activity_chicken_chorus_unlocked",
					image = "buttons/activity_level_chicken_chorus",
					mask = exists("buttons/activity_level_chicken_chorus.mask.png"),
				},
				
				Bitmap
				{
					name = "activity_dough_ball_unlocked",
					image = "buttons/activity_level_dough_ball",
					mask = exists("buttons/activity_level_dough_ball.mask.png"),
				},				
				
				SetStyle(ActivityHeaderSmallTextStyle);
				Text
				{
					font = {standardFont, 22, BlackColor },
					flags=kVAlignTop+kHAlignCenter,
					name = "activitytext",
					x=260,
					w=280,
					y=40,
				},
				
				SetStyle(ActivitySubHeaderTextStyle);
				Text
				{
					font = {standardFont, 20, BlackColor },
					flags=kVAlignTop+kHAlignCenter,
					label = "activitysubtext",
					name = "activitysubtext",
					x=280,
					w=240,
					y=111,
				},
				
				SetStyle(ActivityHeaderSmallTextStyle);
				Text
				{
					flags=kVAlignTop+kHAlignCenter,
					name = "activitytotalscoretext",
					label="activitytotalscore_level",
					x = 565,
					w=100,
					y=107,
				},
				
				SetStyle(ActivityHeaderSmallTextStyle);
				Text
				{
					font = {standardFont, 20, BlackColor },
					flags=kVAlignTop+kHAlignCenter,
					name = "activitytotalscorenum",
					x=565,
					w=100,
					y=140,
				},
				
				SetStyle( ThinButtonStyle ),
				TChooseScene
				{
					name = "playwindow",
					w = kMax, h = kMax,
				
					Button
					{
						name="play",
						label="play",
						
						align=kHAlignCenter+kVAlignBottom,
						
						x = 350,
						y = 515,
						type = kPush,
						
						command = function()
							SetCurrentGameMode(selectedgamemode);
							game:Set("activity_mode", 1);
							game:Set("activity_mode_level", selectedlevel);
							if JumpToActivity(selectedactivity) then
								--ModalReturn(true);
								--QuickClose();
								DoModal("scripts/game.lua");
								local activity_name = game:GetString("activity_mode_name");
								UpdateScores(activity_name);
							else
								loaderror();
							end;
						end;
					},
				},
				
			
				SetStyle(ButtonStyle),
				Button
				{
					label="",
					name="back",
					cancel=true,
					align=kHAlignLeft+kVAlignBottom,
					x=20,y=kMax,
					graphics = { "buttons/button_back_up", "buttons/button_back_down", "buttons/button_back_over" },
					command=function() GotoMenu(); end;
				},
				Text
				{
					label="back",
					name="back_text",
					font = BackButtonFont,
					flags = kVAlignTop + kHAlignCenter,
					x=27,y=kMax-70,
					w=50,
					h=40,
				},
				--[[
				Button
				{
					label="",
					name="quit",
					default=true,
					align=kHAlignRight+kVAlignBottom,
					x=kMax-20,y=kMax,
					graphics = { "buttons/button_pause_up", "buttons/button_pause_down", "buttons/button_pause_over" },
					command=function() GotoMainMenu(); end;
				},
				--]]
			},
		}
	--}
}

function UpdateButton(button_name)
	-- if we've finished the game make sure activity modes are unlocked
	if game:HasAward("avenue-flo_finish") then
		if game:Get(button_name .. "_unlocked") < 1 then
			game:Set(button_name .. "_unlocked", 1);
		end
	end
	
	if game:Get(button_name .. "_unlocked") > 0 then
		EnableWindow(button_name .. "_locked", false);
	else
		EnableWindow(button_name .. "_unlocked", false);
	end
end

function UpdateButtons()
	GotoMenu();
	
	UpdateButton("beading");
	UpdateButton("clothing");
	UpdateButton("package");
	UpdateButton("chicken_field");
	UpdateButton("chicken_chorus");
	UpdateButton("dough_ball");
end

function UpdateScores(activity_name)	
	local levelsunlocked = game:Get(activity_name .. "_unlocked");
	--local levelsunlocked = 15;
	local totalscore = 0;
	
	for i = 1, 16 do
		EnableWindow("scorenum_" .. i .. "_unlocked", levelsunlocked >= i);
		EnableWindow("scorenum_" .. i .. "_locked", levelsunlocked < i);
		local score = game:Get(activity_name .. "_level_" .. i .. "_score");
		local expert = game:Get(activity_name .. "_level_" .. i .. "_expert");
		--local expert = 1;
		--local score = 800;
		
		if score == nil then
			score = 0;
		end;
		
		if levelsunlocked >= i then
			if score == 0 then
				EnableWindow("score_" .. i, false);
			else
				EnableWindow("score_" .. i, true);
				SetLabel("score_" .. i, tostring(score));
			end
			totalscore = totalscore + score;
			
			if expert > 0 then
				EnableWindow("expert_" .. i, true);
			else
				EnableWindow("expert_" .. i, false);
			end
			
			EnableWindow("levelbutton_" .. i, true);
			SetButtonToggleState("levelbutton_" .. i, true);
		else
			EnableWindow("score_" .. i, false);
			EnableWindow("expert_" .. i, false);
			EnableWindow("levelbutton_" .. i, false);
		end
	end
	
	selectedlevel = levelsunlocked;
	SetLabel("activitytotalscorenum", tostring(totalscore));
end

function GotoSubMenu(activity_name)
	EnableWindow("activitymenu",false)
	EnableWindow("activitysubmenu",true)
	game:SetString("activity_mode_name", activity_name);
	
	EnableWindow("activity_beading_unlocked", false);
	EnableWindow("activity_clothing_unlocked", false);
	EnableWindow("activity_package_unlocked", false);
	EnableWindow("activity_chicken_field_unlocked", false);
	EnableWindow("activity_chicken_chorus_unlocked", false);
	EnableWindow("activity_dough_ball_unlocked", false);
	
	if activity_name == "beading" then
		selectedactivity = "mg_bead";
		selectedgamemode = 1;
	elseif activity_name == "clothing" then
		selectedactivity = "mg_clothing";
		selectedgamemode = 2;
	elseif activity_name == "package" then
		selectedactivity = "mg_package";
		selectedgamemode = 3;
	elseif activity_name == "chicken_field" then
		selectedactivity = "mg_chickenfield";
		selectedgamemode = 4;
	elseif activity_name == "chicken_chorus" then
		selectedactivity = "mg_chickenchorus";
		selectedgamemode = 5;
	elseif activity_name == "dough_ball" then
		selectedactivity = "mg_doughball";
		selectedgamemode = 6;
	else
		selectedactivity = "";
	end
	
	--SetBitmap("activityimage", "buttons/activity_" .. activity_name .. "_unlocked", 1);
	EnableWindow("activity_" .. activity_name .. "_unlocked", true);
	SetLabel("activitytext", GetString("activity_" .. activity_name));
	
	UpdateScores(activity_name);
end

function GotoMenu()
	EnableWindow("activitymenu",true)
	EnableWindow("activitysubmenu",false)
end

UpdateButtons();